<?php
# MetInfo Enterprise Content Management System
# Copyright (C) MetInfo Co.,Ltd (http://www.metinfo.cn). All rights reserved.
defined('IN_MET') or exit('No permission');
$html_class=$body_class='h-100';
$html_class.=' met-login';
$body_class.=' d-flex align-items-center justify-content-center';
$met_title=$word['logintitle'].'-'.$word['metinfo'];
$login_logo_filemtime=filemtime(str_replace($url['site'], PATH_WEB, $data['met_agents_logo_login']));
$basic_admin_css_filemtime = filemtime(PATH_PUBLIC_ADMIN.'css/basic_admin.css');
$favicon_filemtime = filemtime(PATH_WEB."favicon.ico");
$synchronous=$_M['langlist']['admin'][$_M['langset']]['synchronous'];
// dump($data);
?>
<!DOCTYPE HTML>
<html class="{$html_class}">
<head>
<meta charset="utf-8">
<meta name="renderer" content="webkit">
<meta name="robots" content="noindex,nofllow">
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=0,minimal-ui">
<meta name="format-detection" content="telephone=no">
<title>{$met_title}</title>
<meta name="generator" content="MetInfo V{$c.metcms_v}" data-variable="{$url.site}|{$_M['lang']}|{$synchronous}|{$c.met_skin_user}||||">
<link href="{$url.site}favicon.ico?{$favicon_filemtime}" rel="shortcut icon" type="image/x-icon">
<link href="{$url.public_admin}css/basic_admin.css?{$basic_admin_css_filemtime}" rel='stylesheet' type='text/css'>
<if value="$data['qrcode']">
<style>
    .btn-change-login-method{right: -15px;top: -30px;}
</style>
</if>
</head>
<body class="{$body_class}">
<div>
    <style>.met-ie-tips a{color: #fff;}</style>
    <div class="text-center mb-0 bg-danger alert hide mb-3 met-ie-tips">
        <button type="button" class="close" data-dismiss="alert">
            <span aria-hidden="true">×</span>
        </button>
        你正在使用一个 <strong>过时</strong> 的浏览器。请 <a href='https://browsehappy.com/' target=_blank>升级您的浏览器</a>，以提高您的体验。
    </div>
    <h1 class="h4 mb-5 mt-0 text-center">{$word.loginadmin}</h1>
    <div class="d-flex text-left align-items-center position-relative">
        <a href="{$data.met_agents_linkurl}" title="{$word.metinfo}" target="_blank" class="text-center" style="width: 254px;">
            <img src="{$data.met_agents_logo_login}?{$login_logo_filemtime}" alt="{$word.metinfo}" width="200">
        </a>
        <view class="border-left pl-2 ml-4" style="border-color: #eee !important;">
            <if value="$data['qrcode']">
                <view class="row d-flex justify-content-end mb-4 btn-change-login-method">
                    <a href="javascript:;" data-method="weixin" class="item d-flex align-items-center">
                        微信扫码登录<i class="fa-qrcode h4 my-0 ml-2"></i>
                    </a>
                    <a href="javascript:;" data-method="username" class="item d-flex align-items-center hide" role="button">
                        账号密码登录<i class="fa-desktop h4 my-0 ml-2"></i>
                    </a>
                </view>
            </if>
            <form action="{$url.own_form}a=dologin" class="met-login-form login-method" data-method="username" data-submit-ajax="1">
                <input type="hidden" name="referrer" value="{$data.referrer}">
                <if value="$c['met_admin_type_ok']">
                    <div class="row">
                        <label class="col-form-label pr-3 text-right" style="width: 100px;">{$word.loginlanguage}</label>
                        <div class="form-group mb-4">
                            <select name="langset" data-checked="{$data.langset}" class="form-control" onchange="javascript:location.href=M.url.admin+'?langset='+this.value">
                                <list data="$data['met_langadmin']" name="$v">
                                    <option value="{$v.mark}">{$v.name}</option>
                                </list>
                            </select>
                        </div>
                    </div>
                </if>
                <div class="row">
                    <label class="col-form-label pr-3 text-right" style="width: 100px;padding:0.25rem 0;">{$word.loginusename}</label>
                    <div class="form-group mb-4">
                        <input type="text" name="login_name" data-safety required class="form-control" style="width: 200px;">
                    </div>
                </div>
                <div class="row">
                    <label class="col-form-label pr-3 text-right" style="width: 100px;padding:0.25rem 0;">{$word.loginpassword}</label>
                    <div class="form-group mb-4">
                        <input type="password" name="login_pass" data-safety required class="form-control" style="width: 200px;">
                    </div>
                </div>
                <!--图形验证码-->
                <div class="row captcha <if value="!$data['captcha']">hide</if>">
                    <label class="col-form-label pr-3 text-right" style="width: 100px;padding:0.25rem 0;">{$word.logincode}</label>
                    <div class="form-group mb-4">
                        <div class="input-group" style="width: 200px;">
                            <input name='code' type='text' class='form-control' placeholder='{$word.memberImgCode}' required>
                            <div class="input-group-append">
                                <div class="input-group-text py-0 px-1">
                                    <img <if value="$data['captcha']">src<else/>data-src</if>='{$url.entrance}?m=include&c=ajax_pin&a=dogetpin&random={$data.random}' title='{$word.memberTip1}' align='absmiddle' role='button' <if value="$data['captcha']">class="met-getcode"</if>>
                                    <input type="hidden" name="random" value="{$data.random}">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <label class="col-form-label" style="width: 100px;"></label>
                    <div class="">
                        <button type="submit" class="btn btn-primary px-4">{$word.loginconfirm}</button>
                        <a href="{$url.get_pass}" class="ml-3">{$word.loginforget}</a>
                    </div>
                </div>
            </form>
            <if value="$data['qrcode']">
            <div class="qrcode-wrapper pl-5 hide row text-center login-method" data-method="weixin" data-login_code="{$data.login_code}">
                <view>
                    <p class="h4 mt-0 mb-3">微信扫码登录</p>
                    <img src="{$data.qrcode}" width="200" class="border">
                    <div class="mt-2 text-grey">打开微信，扫一扫登录</div>
                </view>
            </div>
            </if>
        </view>
    </div>
    <footer class="metadmin-foot text-grey text-center mt-5 pt-5">{$data.copyright}</footer>
</div>
<?php
$basic_admin_js_time = filemtime(PATH_PUBLIC_ADMIN.'js/basic_admin.js');
$lang_json_admin_js_time = filemtime(PATH_WEB.'cache/lang_json_admin_'.$_M['lang'].'.js');
?>
</body>
<script>window.MET={$data.met_para};</script>
<script src="{$url.public_admin}js/basic_admin.js?{$basic_admin_js_time}"></script>
<script src="{$url.site}cache/lang_json_admin_{$_M['langset']}.js?{$lang_json_admin_js_time}"></script>
<if value="$data['qrcode']">
<?php $login_js_time = filemtime(PATH_SYS.'login/admin/templates/js/login.js'); ?>
<script src="{$url.own_tem}js/login.js?{$login_js_time}"></script>
</if>
<script>(function(){M.is_ie&&$('.met-ie-tips').removeClass('hide');})();</script>
<!--插件代码-->
{$_M['html_plugin']['foot_script_admin']}
</html>